# Friday, 15th August, 2025
So, as is very common with me, I have an overly ambitious idea.

I've been consuming a lot of fighting game content within the past few weeks and
I'd like to try my hand at making one.

But, of course, I can never just be normal and make a fighting game. Instead, I
have opted to make a community-driven engine for fighting games, both as a
technical exercise and to learn how to manage a larger project.

I'm mostly focusing on the programming aspect of it, although I could probably
get some friends to help make starting characters for it  and then from their
we can get some fun campaigns going. The language of choice will be C99.

An important thing I want from this game is some good tutorials. In my currently
limited experience with fighting games, my biggest complaint is that for almost
every single one of these games, to get even mildly mediocre at it, I have to
go outside of the game and watch some tutorials on it. This problem ranges from
kinda bad (Skullgirls) to **really bad** (Your Only Move Is Hustle).

I've drafted out a basic plan for this 2.5D fighting game engine thingy:
1. Get some netcode in there. I would just steal GGPO, but then I wouldn't learn
anything :( (Also, that seems more annoying to integrate into my code that it is
worth).
2. Get some graphics in there. I'd like to make a cross-platform WebGPU engine,
as I believe it is the most portable GPU API right now.
3. Get some fighting in there. This is the point where I'll have to play more
fighting games so I can think of mechanics that are flexible enough for
anyone to make characters for, interesting enough to keep people engaged in
combat and simple enough so that I don't want to commit seppuku while coding it.
This is also probably the longest step, since there's a lot of things that go
into it (i.e. hitboxes, frame timing, hitstun).
4. Get some AI in there. This is very important for single-player content.
5. Get some cutscenes in there. A big thing I want is both visual novel style
cutscenes (i.e. dialogue boxes and choices) and FMV cutscenes with actual
direction and framing.
6. Get some modding in there. Expose character settings (i.e. attacks, hitboxes),
asset imports, campaign creation, AI settings, basically everything I've worked
on up to this point to a FFI interface. I can't decide whether I just want to
use one standard scripting language like Lua, or allow something like WebAssembly
so that people can choose their own languages. Either way, this is the crux of
the idea, so it's important to get this right. I might actually need to shift
this up the schedule depending on how difficult it will be to monkey patch it in.
7. Get some menu in there. Main menus, pause menus, settings menus, all the
menus.
8. Get some campaigns in there. I could get really experimental with the story,
but I'm probably not going to do that. We'll just make a basic world with some
characters so that I can get most of the games mechanics explained to the player.
9. Get some polish in there. Something worth doing is worth doing well.
10. Get some documentation in there. People aren't gonna mod the game if they
have to trudge through 1000s of lines of C code just to learn how.
11. Get some community in there. This technically can be done while I'm making
the previous steps, but it would probably look better if I did it after.

This is a very loose plan, since this is a very loose project that I'm not too
concerned about scheduling. I'll work on it when I get the chance and I'll hash
out more details when I get to each step.
